/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.audio.codec.opus;

import com.plasmoverse.opus.OpusDecoder;
import com.plasmoverse.opus.OpusException;
import java.io.IOException;
import su.plo.voice.api.audio.codec.CodecException;
import su.plo.voice.audio.codec.opus.BaseOpusDecoder;

public final class NativeOpusDecoder
implements BaseOpusDecoder {
    private final int sampleRate;
    private final int channels;
    private final int frameSize;
    private OpusDecoder decoder;

    public NativeOpusDecoder(int sampleRate, boolean stereo, int frameSize) {
        this.sampleRate = sampleRate;
        this.channels = stereo ? 2 : 1;
        this.frameSize = frameSize;
    }

    @Override
    public short[] decode(byte[] encoded) throws CodecException {
        if (!this.isOpen()) {
            throw new CodecException("Decoder is not open");
        }
        try {
            return this.decoder.decode(encoded);
        }
        catch (OpusException e) {
            throw new CodecException("Failed to decode audio: " + e);
        }
    }

    @Override
    public void open() throws CodecException {
        try {
            this.decoder = OpusDecoder.create(this.sampleRate, this.channels == 2, this.frameSize);
        }
        catch (OpusException | IOException e) {
            throw new CodecException("Failed to open opus decoder", e);
        }
    }

    @Override
    public void reset() {
        if (!this.isOpen()) {
            return;
        }
        this.decoder.reset();
    }

    @Override
    public void close() {
        if (!this.isOpen()) {
            return;
        }
        this.decoder.close();
        this.decoder = null;
    }

    @Override
    public boolean isOpen() {
        return this.decoder != null;
    }

    @Override
    public short[] decodePLC() throws CodecException {
        return this.decode(null);
    }
}

