/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.encryption.aes;

import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.jetbrains.annotations.NotNull;
import su.plo.voice.api.encryption.Encryption;
import su.plo.voice.api.encryption.EncryptionException;

public final class AesEncryption
implements Encryption {
    public static final String CIPHER = "AES/CBC/PKCS5Padding";
    @NotNull
    private SecretKeySpec key;
    private final SecureRandom random = new SecureRandom();

    public AesEncryption(byte[] keyData) {
        this.key = new SecretKeySpec(keyData, "AES");
    }

    @Override
    public byte[] encrypt(byte[] data) throws EncryptionException {
        try {
            IvParameterSpec iv = this.generateIv();
            Cipher cipher = Cipher.getInstance(CIPHER);
            cipher.init(1, (Key)this.key, iv);
            byte[] encrypted = cipher.doFinal(data);
            return this.copyIvEncrypted(iv, encrypted);
        }
        catch (Exception e) {
            throw new EncryptionException("Failed to encrypt data", e);
        }
    }

    @Override
    public byte[] decrypt(byte[] encrypted) throws EncryptionException {
        try {
            IvParameterSpec iv = this.ivFromEncrypted(encrypted);
            Cipher cipher = Cipher.getInstance(CIPHER);
            cipher.init(2, (Key)this.key, iv);
            encrypted = this.dataFromEncrypted(encrypted);
            return cipher.doFinal(encrypted);
        }
        catch (Exception e) {
            throw new EncryptionException("Failed to decrypt data", e);
        }
    }

    @Override
    public void updateKeyData(byte[] keyData) {
        this.key = new SecretKeySpec(keyData, "AES");
    }

    @Override
    @NotNull
    public SecretKeySpec getKey() {
        return this.key;
    }

    @Override
    @NotNull
    public String getName() {
        return CIPHER;
    }

    private IvParameterSpec generateIv() {
        byte[] iv = new byte[16];
        this.random.nextBytes(iv);
        return new IvParameterSpec(iv);
    }

    private byte[] copyIvEncrypted(IvParameterSpec iv, byte[] encrypted) {
        byte[] encryptedIv = new byte[iv.getIV().length + encrypted.length];
        System.arraycopy(iv.getIV(), 0, encryptedIv, 0, iv.getIV().length);
        System.arraycopy(encrypted, 0, encryptedIv, iv.getIV().length, encrypted.length);
        return encryptedIv;
    }

    private IvParameterSpec ivFromEncrypted(byte[] encrypted) {
        byte[] iv = new byte[16];
        System.arraycopy(encrypted, 0, iv, 0, iv.length);
        return new IvParameterSpec(iv);
    }

    private byte[] dataFromEncrypted(byte[] encrypted) {
        byte[] data = new byte[encrypted.length - 16];
        System.arraycopy(encrypted, 16, data, 0, data.length);
        return data;
    }
}

