/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.proto.data.audio.source;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import java.io.IOException;
import java.util.UUID;
import su.plo.voice.proto.data.audio.source.SourceInfo;
import su.plo.voice.proto.packets.PacketSerializable;
import su.plo.voice.proto.packets.PacketUtil;

public class SelfSourceInfo
implements PacketSerializable {
    private SourceInfo sourceInfo;
    private UUID playerId;
    private UUID activationId;
    private long sequenceNumber;

    @Override
    public void deserialize(ByteArrayDataInput in) throws IOException {
        this.sourceInfo = SourceInfo.of(in);
        this.playerId = PacketUtil.readUUID(in);
        this.activationId = PacketUtil.readUUID(in);
        this.sequenceNumber = in.readLong();
    }

    @Override
    public void serialize(ByteArrayDataOutput out) throws IOException {
        ((SourceInfo)Preconditions.checkNotNull((Object)this.sourceInfo)).serialize(out);
        PacketUtil.writeUUID(out, this.playerId);
        PacketUtil.writeUUID(out, this.activationId);
        out.writeLong(this.sequenceNumber);
    }

    public SelfSourceInfo(SourceInfo sourceInfo, UUID playerId, UUID activationId, long sequenceNumber) {
        this.sourceInfo = sourceInfo;
        this.playerId = playerId;
        this.activationId = activationId;
        this.sequenceNumber = sequenceNumber;
    }

    public SelfSourceInfo() {
    }

    public String toString() {
        return "SelfSourceInfo(sourceInfo=" + this.getSourceInfo() + ", playerId=" + this.getPlayerId() + ", activationId=" + this.getActivationId() + ", sequenceNumber=" + this.getSequenceNumber() + ")";
    }

    public SourceInfo getSourceInfo() {
        return this.sourceInfo;
    }

    public UUID getPlayerId() {
        return this.playerId;
    }

    public UUID getActivationId() {
        return this.activationId;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }
}

