/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.proto.packets.tcp.clientbound;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import java.io.IOException;
import java.util.UUID;
import su.plo.slib.api.entity.player.McGameProfile;
import su.plo.voice.proto.packets.Packet;
import su.plo.voice.proto.packets.PacketUtil;
import su.plo.voice.proto.packets.tcp.clientbound.ClientPacketTcpHandler;
import su.plo.voice.proto.serializer.McGameProfileSerializer;

public final class SourceLinePlayerAddPacket
implements Packet<ClientPacketTcpHandler> {
    private UUID lineId;
    private McGameProfile player;

    @Override
    public void read(ByteArrayDataInput in) throws IOException {
        this.lineId = PacketUtil.readUUID(in);
        this.player = McGameProfileSerializer.INSTANCE.deserialize(in);
    }

    @Override
    public void write(ByteArrayDataOutput out) throws IOException {
        PacketUtil.writeUUID(out, (UUID)Preconditions.checkNotNull((Object)this.lineId));
        McGameProfileSerializer.INSTANCE.serialize((McGameProfile)Preconditions.checkNotNull((Object)this.player), out);
    }

    @Override
    public void handle(ClientPacketTcpHandler handler) {
        handler.handle(this);
    }

    public SourceLinePlayerAddPacket(UUID lineId, McGameProfile player) {
        this.lineId = lineId;
        this.player = player;
    }

    public SourceLinePlayerAddPacket() {
    }

    public String toString() {
        return "SourceLinePlayerAddPacket(lineId=" + this.getLineId() + ", player=" + this.getPlayer() + ")";
    }

    public UUID getLineId() {
        return this.lineId;
    }

    public McGameProfile getPlayer() {
        return this.player;
    }
}

