/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.proto.packets.udp.clientbound;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import java.io.IOException;
import java.util.Optional;
import java.util.UUID;
import su.plo.voice.proto.packets.Packet;
import su.plo.voice.proto.packets.PacketUtil;
import su.plo.voice.proto.packets.udp.clientbound.ClientPacketUdpHandler;

public final class SelfAudioInfoPacket
implements Packet<ClientPacketUdpHandler> {
    private UUID sourceId;
    private long sequenceNumber;
    private byte[] data;
    private short distance;

    public Optional<byte[]> getData() {
        return Optional.ofNullable(this.data);
    }

    @Override
    public void read(ByteArrayDataInput in) throws IOException {
        this.sourceId = PacketUtil.readUUID(in);
        this.sequenceNumber = in.readLong();
        if (in.readBoolean()) {
            int length = PacketUtil.readSafeInt(in, 1, 2048);
            byte[] data = new byte[length];
            in.readFully(data);
            this.data = data;
        }
        this.distance = in.readShort();
    }

    @Override
    public void write(ByteArrayDataOutput out) throws IOException {
        PacketUtil.writeUUID(out, (UUID)Preconditions.checkNotNull((Object)this.sourceId, (Object)"sourceId"));
        out.writeLong(this.sequenceNumber);
        out.writeBoolean(this.data != null);
        if (this.data != null) {
            out.writeInt(this.data.length);
            out.write(this.data);
        }
        out.writeShort((int)this.distance);
    }

    @Override
    public void handle(ClientPacketUdpHandler handler) {
        handler.handle(this);
    }

    public SelfAudioInfoPacket(UUID sourceId, long sequenceNumber, byte[] data, short distance) {
        this.sourceId = sourceId;
        this.sequenceNumber = sequenceNumber;
        this.data = data;
        this.distance = distance;
    }

    public SelfAudioInfoPacket() {
    }

    public String toString() {
        return "SelfAudioInfoPacket(sourceId=" + this.getSourceId() + ", sequenceNumber=" + this.getSequenceNumber() + ", data=" + this.getData() + ", distance=" + this.getDistance() + ")";
    }

    public UUID getSourceId() {
        return this.sourceId;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public short getDistance() {
        return this.distance;
    }
}

