/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.audio.source;

import java.util.UUID;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.slib.api.server.position.ServerPos3d;
import su.plo.voice.api.addon.AddonContainer;
import su.plo.voice.api.event.Event;
import su.plo.voice.api.server.PlasmoVoiceServer;
import su.plo.voice.api.server.audio.capture.PlayerActivationInfo;
import su.plo.voice.api.server.audio.line.ServerSourceLine;
import su.plo.voice.api.server.audio.provider.AudioFrameProvider;
import su.plo.voice.api.server.audio.source.AudioSender;
import su.plo.voice.api.server.audio.source.ServerProximitySource;
import su.plo.voice.api.server.config.ServerConfig;
import su.plo.voice.api.server.event.audio.source.ServerSourceAudioPacketEvent;
import su.plo.voice.api.server.event.audio.source.ServerSourcePacketEvent;
import su.plo.voice.api.server.player.VoicePlayer;
import su.plo.voice.api.server.socket.UdpServerConnection;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.Unit;
import su.plo.voice.libs.kotlin.jvm.functions.Function1;
import su.plo.voice.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.proto.data.audio.codec.CodecInfo;
import su.plo.voice.proto.data.audio.source.SourceInfo;
import su.plo.voice.proto.packets.Packet;
import su.plo.voice.proto.packets.tcp.clientbound.SourceInfoPacket;
import su.plo.voice.proto.packets.udp.clientbound.SourceAudioPacket;
import su.plo.voice.server.audio.source.BaseServerAudioSource;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 **\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004:\u0001*B9\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\"\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\u001c\u0010!\u001a\u00020\u00102\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\"2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010#\u001a\u00020\fH\u0016J\u001e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001e0)H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00148V@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006+"}, d2={"Lsu/plo/voice/server/audio/source/VoiceServerProximitySource;", "S", "Lsu/plo/voice/proto/data/audio/source/SourceInfo;", "Lsu/plo/voice/server/audio/source/BaseServerAudioSource;", "Lsu/plo/voice/api/server/audio/source/ServerProximitySource;", "voiceServer", "Lsu/plo/voice/api/server/PlasmoVoiceServer;", "addon", "Lsu/plo/voice/api/addon/AddonContainer;", "id", "Ljava/util/UUID;", "serverSourceLine", "Lsu/plo/voice/api/server/audio/line/ServerSourceLine;", "decoderInfo", "Lsu/plo/voice/proto/data/audio/codec/CodecInfo;", "stereo", "", "<init>", "(Lsu/plo/voice/api/server/PlasmoVoiceServer;Lsu/plo/voice/api/addon/AddonContainer;Ljava/util/UUID;Lsu/plo/voice/api/server/audio/line/ServerSourceLine;Lsu/plo/voice/proto/data/audio/codec/CodecInfo;Z)V", "value", "", "angle", "getAngle", "()I", "setAngle", "(I)V", "sendAudioPacket", "packet", "Lsu/plo/voice/proto/packets/udp/clientbound/SourceAudioPacket;", "distance", "", "activationInfo", "Lsu/plo/voice/api/server/audio/capture/PlayerActivationInfo;", "sendPacket", "Lsu/plo/voice/proto/packets/Packet;", "getLine", "createAudioSender", "Lsu/plo/voice/api/server/audio/source/AudioSender;", "frameProvider", "Lsu/plo/voice/api/server/audio/provider/AudioFrameProvider;", "distanceProvider", "Ljava/util/function/Supplier;", "Companion", "common"})
public abstract class VoiceServerProximitySource<S extends SourceInfo>
extends BaseServerAudioSource<S>
implements ServerProximitySource<S> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PlasmoVoiceServer voiceServer;
    @NotNull
    private final ServerSourceLine serverSourceLine;
    private int angle;
    private static final int DISTANCE_MULTIPLIER = 2;

    public VoiceServerProximitySource(@NotNull PlasmoVoiceServer voiceServer, @NotNull AddonContainer addon, @NotNull UUID id, @NotNull ServerSourceLine serverSourceLine, @Nullable CodecInfo decoderInfo, boolean stereo) {
        Intrinsics.checkNotNullParameter(voiceServer, "voiceServer");
        Intrinsics.checkNotNullParameter(addon, "addon");
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(serverSourceLine, "serverSourceLine");
        super(addon, id, serverSourceLine, decoderInfo, stereo);
        this.voiceServer = voiceServer;
        this.serverSourceLine = serverSourceLine;
    }

    @Override
    public int getAngle() {
        return this.angle;
    }

    @Override
    public void setAngle(int value) {
        this.angle = value;
    }

    @Override
    public boolean sendAudioPacket(@NotNull SourceAudioPacket packet, short distance, @Nullable PlayerActivationInfo activationInfo) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        ServerSourceAudioPacketEvent event = new ServerSourceAudioPacketEvent(this, packet, distance, activationInfo);
        if (!this.voiceServer.getEventBus().fire((Event)event)) {
            return false;
        }
        if (event.getResult() == ServerSourceAudioPacketEvent.Result.HANDLED) {
            return true;
        }
        packet.setSourceState((byte)this.state.get());
        short s = event.getDistance();
        ServerConfig serverConfig = this.voiceServer.getConfig();
        Intrinsics.checkNotNull(serverConfig);
        int listenersDistance = Math.min(s + serverConfig.voice().maxExtraAudioBroadcastDistance(), event.getDistance() * 2);
        if (this.dirty.compareAndSet(true, false)) {
            this.resolveSourceInfo().thenAccept(arg_0 -> VoiceServerProximitySource.sendAudioPacket$lambda$1(arg_0 -> VoiceServerProximitySource.sendAudioPacket$lambda$0(this, listenersDistance, arg_0), arg_0));
        }
        ServerPos3d playerPosition = new ServerPos3d();
        ServerPos3d sourcePosition = this.getPosition();
        double distanceSquared = listenersDistance * listenersDistance;
        for (UdpServerConnection connection : this.voiceServer.getUdpConnectionManager().getConnections()) {
            if (this.notMatchFilters((VoicePlayer)connection.getPlayer())) continue;
            connection.getPlayer().getInstance().getServerPosition(playerPosition);
            if (!Intrinsics.areEqual(sourcePosition.getWorld(), playerPosition.getWorld()) || !(sourcePosition.distanceSquared(playerPosition) <= distanceSquared)) continue;
            connection.sendPacket(packet);
        }
        return true;
    }

    @Override
    public boolean sendPacket(@NotNull Packet<?> packet, short distance) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        ServerSourcePacketEvent event = new ServerSourcePacketEvent(this, packet, distance);
        if (!this.voiceServer.getEventBus().fire((Event)event)) {
            return false;
        }
        if (event.getResult() == ServerSourcePacketEvent.Result.HANDLED) {
            return true;
        }
        short s = event.getDistance();
        ServerConfig serverConfig = this.voiceServer.getConfig();
        Intrinsics.checkNotNull(serverConfig);
        int listenersDistance = Math.min(s + serverConfig.voice().maxExtraAudioBroadcastDistance(), event.getDistance() * 2);
        ServerPos3d playerPosition = new ServerPos3d();
        ServerPos3d sourcePosition = this.getPosition();
        double distanceSquared = listenersDistance * listenersDistance;
        for (UdpServerConnection connection : this.voiceServer.getUdpConnectionManager().getConnections()) {
            if (this.notMatchFilters((VoicePlayer)connection.getPlayer())) continue;
            connection.getPlayer().getInstance().getServerPosition(playerPosition);
            if (!Intrinsics.areEqual(sourcePosition.getWorld(), playerPosition.getWorld()) || !(sourcePosition.distanceSquared(playerPosition) <= distanceSquared)) continue;
            connection.getPlayer().sendPacket(packet);
        }
        return true;
    }

    @Override
    @NotNull
    public ServerSourceLine getLine() {
        return this.serverSourceLine;
    }

    @Override
    @NotNull
    public AudioSender createAudioSender(@NotNull AudioFrameProvider frameProvider, @NotNull Supplier<Short> distanceProvider) {
        Intrinsics.checkNotNullParameter(frameProvider, "frameProvider");
        Intrinsics.checkNotNullParameter(distanceProvider, "distanceProvider");
        return new AudioSender(frameProvider, (arg_0, arg_1) -> VoiceServerProximitySource.createAudioSender$lambda$2(this, distanceProvider, arg_0, arg_1), arg_0 -> VoiceServerProximitySource.createAudioSender$lambda$3(this, distanceProvider, arg_0));
    }

    private static final Unit sendAudioPacket$lambda$0(VoiceServerProximitySource this$0, int $listenersDistance, SourceInfo it) {
        this$0.sendPacket(new SourceInfoPacket(it), (short)$listenersDistance);
        return Unit.INSTANCE;
    }

    private static final void sendAudioPacket$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final boolean createAudioSender$lambda$2(VoiceServerProximitySource this$0, Supplier $distanceProvider, byte[] frame, long sequenceNumber) {
        Intrinsics.checkNotNullParameter(frame, "frame");
        Object t = $distanceProvider.get();
        Intrinsics.checkNotNullExpressionValue(t, "get(...)");
        return this$0.sendAudioFrame(frame, sequenceNumber, ((Number)t).shortValue());
    }

    private static final boolean createAudioSender$lambda$3(VoiceServerProximitySource this$0, Supplier $distanceProvider, long sequenceNumber) {
        Object t = $distanceProvider.get();
        Intrinsics.checkNotNullExpressionValue(t, "get(...)");
        return this$0.sendAudioEnd(sequenceNumber, ((Number)t).shortValue());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lsu/plo/voice/server/audio/source/VoiceServerProximitySource$Companion;", "", "<init>", "()V", "DISTANCE_MULTIPLIER", "", "common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

