/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.command;

import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.slib.api.chat.component.McTextComponent;
import su.plo.slib.api.command.McCommand;
import su.plo.slib.api.command.McCommandSource;
import su.plo.slib.api.entity.player.McGameProfile;
import su.plo.slib.api.server.McServerLib;
import su.plo.voice.api.server.mute.MuteManager;
import su.plo.voice.server.BaseVoiceServer;

public final class VoiceUnmuteCommand
implements McCommand {
    private final BaseVoiceServer voiceServer;
    private final McServerLib minecraftServer;

    @Override
    public void execute(@NotNull McCommandSource source2, @NotNull String[] arguments) {
        McGameProfile player;
        if (arguments.length == 0) {
            source2.sendMessage(McTextComponent.translatable("pv.command.unmute.usage", new Object[0]));
            return;
        }
        try {
            player = this.minecraftServer.getGameProfile(UUID.fromString(arguments[0]));
        }
        catch (Exception e) {
            player = this.minecraftServer.getGameProfile(arguments[0]);
        }
        if (player == null) {
            source2.sendMessage(McTextComponent.translatable("pv.error.player_not_found", new Object[0]));
            return;
        }
        MuteManager muteManager = this.voiceServer.getMuteManager();
        if (!muteManager.unmute(player.getId(), false).isPresent()) {
            source2.sendMessage(McTextComponent.translatable("pv.command.unmute.not_muted", player.getName()));
            return;
        }
        source2.sendMessage(McTextComponent.translatable("pv.command.unmute.unmuted", player.getName()));
    }

    @Override
    public boolean hasPermission(@NotNull McCommandSource source2, @Nullable String[] arguments) {
        return source2.hasPermission("pv.unmute");
    }

    @Override
    @NotNull
    public List<String> suggest(@NotNull McCommandSource source2, @NotNull String[] arguments) {
        if (arguments.length <= 1) {
            String argument = arguments.length > 0 ? arguments[0] : "";
            return this.voiceServer.getMuteManager().getMuteStorage().getMutedPlayers().stream().map(muteInfo -> {
                McGameProfile player = this.minecraftServer.getGameProfile(muteInfo.getPlayerUUID());
                if (player == null) {
                    return muteInfo.getPlayerUUID().toString();
                }
                return player.getName();
            }).filter(player -> player.regionMatches(true, 0, argument, 0, argument.length())).collect(Collectors.toList());
        }
        return McCommand.super.suggest(source2, arguments);
    }

    public VoiceUnmuteCommand(BaseVoiceServer voiceServer, McServerLib minecraftServer) {
        this.voiceServer = voiceServer;
        this.minecraftServer = minecraftServer;
    }
}

