/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.utils;

import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_11659;
import net.minecraft.class_124;
import net.minecraft.class_151;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5250;
import net.minecraft.class_630;
import net.minecraft.class_7417;
import net.minecraft.class_746;
import net.minecraft.class_8828;
import net.minecraft.class_918;
import net.minecraft.class_9848;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import traben.entity_texture_features.ETF;
import traben.entity_texture_features.config.ETFConfigWarning;
import traben.entity_texture_features.config.ETFConfigWarnings;
import traben.entity_texture_features.features.ETFManager;
import traben.entity_texture_features.features.ETFRenderContext;
import traben.entity_texture_features.features.state.ETFEntityRenderState;
import traben.entity_texture_features.features.texture_handlers.ETFTexture;

public abstract class ETFUtils2 {
    @NotNull
    public static class_2960 res(String fullPath) {
        return class_2960.method_60654((String)fullPath);
    }

    @NotNull
    public static class_2960 res(String namespace, String path) {
        return class_2960.method_60655((String)namespace, (String)path);
    }

    public static void setPixel(class_1011 image, int x, int y, int color) {
        image.method_61941(x, y, class_9848.method_61337((int)color));
    }

    public static int getPixel(class_1011 image, int x, int y) {
        return class_9848.method_61338((int)image.method_61940(x, y));
    }

    public static void submitModelPart(class_4587 matrixStack, class_11659 submit, int light, class_630 modelPart, ETFTexture etfTexture, @Nullable ETFEntityRenderState state) {
        class_2960 texture = etfTexture.getTextureIdentifier(state);
        class_2960 emissive = etfTexture.getEmissiveIdentifierOfCurrentState();
        class_2960 enchanted = etfTexture.getEnchantIdentifierOfCurrentState();
        ETFUtils2.submitModelPart(matrixStack, submit, light, modelPart, texture, emissive, enchanted);
    }

    public static void submitModelPart(class_4587 matrixStack, class_11659 submit, int light, class_630 modelPart, @NotNull class_2960 texture, @Nullable class_2960 emissive, @Nullable class_2960 enchanted) {
        submit.method_73491(modelPart, matrixStack, class_1921.method_23580((class_2960)texture), light, class_4608.field_21444, null);
        if (emissive != null) {
            ETFUtils2.submitEmissiveModelPart(matrixStack, submit, modelPart, emissive);
        }
        if (enchanted != null) {
            ETFUtils2.submitEnchantedModelPart(matrixStack, submit, light, modelPart, enchanted);
        }
    }

    public static void submitEmissiveModelPart(class_4587 matrixStack, class_11659 submit, class_630 modelPart, @NotNull class_2960 emissive) {
        submit.method_73491(modelPart, matrixStack, class_1921.method_23580((class_2960)emissive), 0xF000F2, class_4608.field_21444, null);
    }

    public static void submitEnchantedModelPart(class_4587 matrixStack, class_11659 submit, int light, class_630 modelPart, @NotNull class_2960 enchanted) {
        submit.method_73493(modelPart, matrixStack, class_1921.method_25448((class_2960)enchanted), light, class_4608.field_21444, null, false, true);
    }

    @Deprecated
    public static void printDebugImage(class_1011 image) {
        if (ETF.isFabric() == ETF.isThisModLoaded("fabric") && ETF.getConfigDirectory() != null) {
            Path outputDirectory = Path.of(ETF.getConfigDirectory().toFile().getParent(), "\\ETF_debug_printout.png");
            try {
                image.method_4314(outputDirectory);
                ETFUtils2.logMessage("printed debug image to: " + String.valueOf(outputDirectory), false);
            }
            catch (Exception e) {
                ETFUtils2.logError(e.toString(), false);
            }
        }
    }

    public static class_2960 getETFVariantNotNullForInjector(class_2960 identifier) {
        class_2960 modified;
        if (identifier == null || ETFRenderContext.getCurrentEntityState() == null || !ETFRenderContext.isAllowedToRenderLayerTextureModify()) {
            return identifier;
        }
        ETFTexture etfTexture = ETFManager.getInstance().getETFTextureVariant(identifier, ETFRenderContext.getCurrentEntityState());
        if (ETFRenderContext.isAllowedToPatch()) {
            etfTexture.assertPatchedTextures();
        }
        return (modified = etfTexture.getTextureIdentifier(ETFRenderContext.getCurrentEntityState())) == null ? identifier : modified;
    }

    public static boolean renderEmissive(ETFTexture texture, class_4597 provider, RenderMethodForOverlay renderer) {
        if (!ETF.config().getConfig().canDoEmissiveTextures()) {
            return false;
        }
        class_2960 emissive = texture.getEmissiveIdentifierOfCurrentState();
        if (emissive != null) {
            boolean wasAllowed = ETFRenderContext.isAllowedToRenderLayerTextureModify();
            ETFRenderContext.preventRenderLayerTextureModify();
            class_4588 emissiveConsumer = provider.method_73477(ETFRenderContext.canRenderInBrightMode() ? class_1921.method_23592((class_2960)emissive, (boolean)true) : class_1921.method_23580((class_2960)emissive));
            if (wasAllowed) {
                ETFRenderContext.allowRenderLayerTextureModify();
            }
            ETFRenderContext.startSpecialRenderOverlayPhase();
            renderer.render(emissiveConsumer, 0xF000F2);
            ETFRenderContext.endSpecialRenderOverlayPhase();
            return true;
        }
        return false;
    }

    public static boolean renderEnchanted(ETFTexture texture, class_4597 provider, int light, RenderMethodForOverlay renderer) {
        class_2960 enchanted = texture.getEnchantIdentifierOfCurrentState();
        if (enchanted != null) {
            boolean wasAllowed = ETFRenderContext.isAllowedToRenderLayerTextureModify();
            ETFRenderContext.preventRenderLayerTextureModify();
            class_4588 enchantedVertex = class_918.method_23181((class_4597)provider, (class_1921)class_1921.method_25448((class_2960)enchanted), (boolean)false, (boolean)true);
            if (wasAllowed) {
                ETFRenderContext.allowRenderLayerTextureModify();
            }
            ETFRenderContext.startSpecialRenderOverlayPhase();
            renderer.render(enchantedVertex, light);
            ETFRenderContext.endSpecialRenderOverlayPhase();
            return true;
        }
        return false;
    }

    @Nullable
    public static class_2960 addVariantNumberSuffix(@NotNull class_2960 identifier, int variant) {
        class_2960 changed = ETFUtils2.res(ETFUtils2.addVariantNumberSuffix(identifier.toString(), variant));
        return identifier.equals((Object)changed) ? null : changed;
    }

    @NotNull
    public static String addVariantNumberSuffix(String identifierString, int variant) {
        String file;
        if (variant < 2) {
            return identifierString;
        }
        String string = file = identifierString.endsWith(".png") ? "png" : identifierString.substring(identifierString.lastIndexOf(46) + 1);
        if (identifierString.matches("\\D+\\d+\\." + file)) {
            return identifierString.replace("." + file, "." + variant + "." + file);
        }
        return identifierString.replace("." + file, variant + "." + file);
    }

    @Nullable
    public static class_2960 replaceIdentifier(class_2960 id, String regex, String replace) {
        if (id == null) {
            return null;
        }
        try {
            return ETFUtils2.res(id.method_12836(), id.method_12832().replaceFirst(regex, replace));
        }
        catch (class_151 idFail) {
            ETFUtils2.logError(ETF.getTextFromTranslation("config.entity_texture_features.illegal_path_recommendation").getString() + "\n" + String.valueOf((Object)idFail));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    public static String returnNameOfHighestPackFromTheseMultiple(String[] packNameList) {
        ArrayList<String> packNames = new ArrayList<String>(Arrays.asList(packNameList));
        ArrayList<String> knownResourcepackOrder = ETFManager.getInstance().KNOWN_RESOURCEPACK_ORDER;
        while (packNames.size() > 1) {
            packNames.remove(knownResourcepackOrder.indexOf(packNames.get(0)) >= knownResourcepackOrder.indexOf(packNames.get(1)) ? 1 : 0);
        }
        return packNames.get(0);
    }

    @Nullable
    public static String returnNameOfHighestPackFromTheseTwo(@Nullable String pack1, @Nullable String pack2) {
        if (pack1 == null) {
            return null;
        }
        if (pack1.equals(pack2) || pack2 == null) {
            return pack1;
        }
        return ETFManager.getInstance().KNOWN_RESOURCEPACK_ORDER.indexOf(pack1) >= ETFManager.getInstance().KNOWN_RESOURCEPACK_ORDER.indexOf(pack2) ? pack1 : pack2;
    }

    @Nullable
    public static Properties readAndReturnPropertiesElseNull(class_2960 path) {
        Properties properties;
        block8: {
            Properties props = new Properties();
            InputStream in = ((class_3298)class_310.method_1551().method_1478().method_14486(path).get()).method_14482();
            try {
                props.load(in);
                properties = props;
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return null;
                }
            }
            in.close();
        }
        return properties;
    }

    @Nullable
    public static List<Properties> readAndReturnAllLayeredPropertiesElseNull(class_2960 path) {
        ArrayList<Properties> props = new ArrayList<Properties>();
        try {
            List resources = class_310.method_1551().method_1478().method_14489(path);
            for (class_3298 resource : resources) {
                if (resource == null) continue;
                try {
                    InputStream in = resource.method_14482();
                    try {
                        Properties prop = new Properties();
                        prop.load(in);
                        if (prop.isEmpty()) continue;
                        props.add(prop);
                    }
                    finally {
                        if (in == null) continue;
                        in.close();
                    }
                }
                catch (Exception exception) {}
            }
            return props.isEmpty() ? null : props;
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static class_1011 getNativeImageElseNull(@Nullable class_2960 identifier) {
        try {
            Optional resource = class_310.method_1551().method_1478().method_14486(identifier);
            if (resource.isPresent()) {
                try (InputStream in = ((class_3298)resource.get()).method_14482();){
                    class_1011 class_10112 = class_1011.method_4309((InputStream)in);
                    return class_10112;
                }
                catch (Exception e) {
                    return null;
                }
            }
            class_1044 texture = class_310.method_1551().method_1531().method_4619(identifier);
            if (!(texture instanceof class_1043)) return null;
            class_1043 nativeImageBackedTexture = (class_1043)texture;
            class_1011 image2 = nativeImageBackedTexture.method_4525();
            if (image2 == null) {
                return null;
            }
            class_1011 image3 = new class_1011(image2.method_4307(), image2.method_4323(), false);
            image3.method_4317(image2);
            return image3;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void logMessage(String obj) {
        ETFUtils2.logMessage(obj, false);
    }

    public static void logMessage(String obj, boolean inChat) {
        if (inChat) {
            class_746 player = class_310.method_1551().field_1724;
            if (player != null) {
                player.method_7353((class_2561)class_5250.method_43477((class_7417)new class_8828.class_2585("\u00a7a[INFO]\u00a7r [ETF]: " + obj)), false);
            } else {
                ETF.LOGGER.info("[ETF]: {}", (Object)obj);
            }
        } else {
            ETF.LOGGER.info("[ETF]: {}", (Object)obj);
        }
    }

    public static void logWarn(String obj) {
        ETFUtils2.logWarn(obj, false);
    }

    public static void logWarn(String obj, boolean inChat) {
        if (inChat) {
            class_746 player = class_310.method_1551().field_1724;
            if (player != null) {
                player.method_7353((class_2561)class_5250.method_43477((class_7417)new class_8828.class_2585("\u00a7e[WARN]\u00a7r [Entity Texture Features]: " + obj)).method_27692(class_124.field_1054), false);
            } else {
                ETF.LOGGER.warn("[ETF]: {}", (Object)obj);
            }
        } else {
            ETF.LOGGER.warn("[ETF]: {}", (Object)obj);
        }
    }

    public static void logError(String obj) {
        ETFUtils2.logError(obj, false);
    }

    public static void logError(String obj, boolean inChat) {
        if (inChat) {
            class_746 player = class_310.method_1551().field_1724;
            if (player != null) {
                player.method_7353((class_2561)class_5250.method_43477((class_7417)new class_8828.class_2585("\u00a74[ERROR]\u00a7r [Entity Texture Features]: " + obj)).method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}), false);
            } else {
                ETF.LOGGER.error("[ETF]: {}", (Object)obj);
            }
        } else {
            ETF.LOGGER.error("[ETF]: {}", (Object)obj);
        }
    }

    public static class_1011 emptyNativeImage() {
        return ETFUtils2.emptyNativeImage(64, 64);
    }

    public static class_1011 emptyNativeImage(int Width, int Height) {
        class_1011 empty = new class_1011(Width, Height, false);
        empty.method_4326(0, 0, Width, Height, 0);
        return empty;
    }

    public static boolean registerNativeImageToIdentifier(class_1011 image, class_2960 identifier) {
        if (image == null || identifier == null) {
            ETFUtils2.logError("registering native image failed: " + String.valueOf(image) + ", " + String.valueOf(identifier));
            return false;
        }
        try {
            class_1011 closableImage = new class_1011(image.method_4307(), image.method_4323(), true);
            closableImage.method_4317(image);
            class_310.method_1551().method_1531().method_4615(identifier);
            class_1043 closableBackedTexture = new class_1043(null, closableImage);
            class_310.method_1551().method_1531().method_4616(identifier, (class_1044)closableBackedTexture);
            return true;
        }
        catch (Exception e) {
            ETFUtils2.logError("registering native image failed: " + String.valueOf(e));
            return false;
        }
    }

    public static void checkModCompatibility() {
        for (ETFConfigWarning warning : ETFConfigWarnings.getRegisteredWarnings()) {
            warning.testWarningAndApplyFixIfEnabled();
        }
    }

    public static interface RenderMethodForOverlay {
        public void render(class_4588 var1, int var2);
    }
}

