/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain.config;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import pigcart.particlerain.VersionUtil;
import pigcart.particlerain.config.ConfigManager;

public abstract class Whitelist<T> {
    @ConfigManager.NoGUI
    private final transient class_5321<class_2378<T>> registry;
    @ConfigManager.NoGUI
    public transient List<class_6862<T>> tags = new ArrayList<class_6862<T>>();
    @ConfigManager.NoGUI
    public transient List<class_2960> ids = new ArrayList<class_2960>();
    @ConfigManager.BooleanFormat(t="whitelist", f="blacklist")
    public boolean isWhitelist;

    Whitelist(class_5321<class_2378<T>> registry, boolean isWhitelist) {
        this.isWhitelist = isWhitelist;
        this.registry = registry;
    }

    Whitelist(class_5321<class_2378<T>> registry) {
        this(registry, true);
    }

    public abstract List<String> getEntries();

    public String toString() {
        return this.getEntries().toString();
    }

    public void populateInternalLists() {
        this.ids.clear();
        this.tags.clear();
        for (String string : this.getEntries()) {
            class_2960 id;
            if (string.startsWith("#")) {
                id = VersionUtil.parseId(string.substring(1));
                if (id == null) continue;
                this.tags.add(class_6862.method_40092(this.registry, (class_2960)id));
                continue;
            }
            id = VersionUtil.parseId(string);
            if (id == null) continue;
            this.ids.add(id);
        }
    }

    public boolean contains(class_6880<T> holder) {
        if (!this.getEntries().isEmpty()) {
            boolean hasMatch;
            for (class_6862<T> tag : this.tags) {
                hasMatch = holder.method_40220(tag);
                if (this.isWhitelist && hasMatch) {
                    return true;
                }
                if (!hasMatch) continue;
                return false;
            }
            for (class_2960 id : this.ids) {
                hasMatch = holder.method_40226(id);
                if (this.isWhitelist && hasMatch) {
                    return true;
                }
                if (!hasMatch) continue;
                return false;
            }
            return !this.isWhitelist;
        }
        return true;
    }

    @ConfigManager.OverrideName(value="Whitelist")
    public static class BiomeList
    extends Whitelist<class_1959> {
        public final transient URI wikiLink = URI.create("https://wiki.fabricmc.net/community:common_tags#biome_tags");
        @ConfigManager.Group
        @ConfigManager.Dropdown(value=ConfigManager.SupplyBiomes.class)
        public List<String> entries;

        BiomeList(boolean isWhitelist, List<String> list) {
            super(class_7924.field_41236, isWhitelist);
            this.entries = list;
        }

        public BiomeList() {
            super(class_7924.field_41236);
            this.entries = new ArrayList<String>();
        }

        @Override
        public List<String> getEntries() {
            return this.entries;
        }
    }

    @ConfigManager.OverrideName(value="Whitelist")
    public static class BlockList
    extends Whitelist<class_2248> {
        public final transient URI wikiLink = URI.create("https://wiki.fabricmc.net/community:common_tags#block_tags");
        @ConfigManager.Group
        @ConfigManager.Dropdown(value=ConfigManager.SupplyBlocks.class)
        public List<String> entries;

        BlockList(boolean isWhitelist, List<String> list) {
            super(class_7924.field_41254, isWhitelist);
            this.entries = list;
        }

        public BlockList() {
            super(class_7924.field_41254);
            this.entries = new ArrayList<String>();
        }

        @Override
        public List<String> getEntries() {
            return this.entries;
        }
    }
}

