/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranim.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.zigythebird.playeranim.PlayerAnimLibMod;
import com.zigythebird.playeranim.animation.PlayerAnimResources;
import com.zigythebird.playeranim.api.PlayerAnimationAccess;
import com.zigythebird.playeranim.commands.AnimationArgumentProvider;
import com.zigythebird.playeranimcore.animation.Animation;
import com.zigythebird.playeranimcore.animation.AnimationController;
import com.zigythebird.playeranimcore.animation.RawAnimation;
import com.zigythebird.playeranimcore.network.AnimationBinary;
import com.zigythebird.playeranimcore.network.LegacyAnimationBinary;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.Objects;
import net.minecraft.class_11890;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2232;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5242;
import net.minecraft.class_7157;

public class PlayerAnimCommands {
    public static <T> void register(CommandDispatcher<T> dispatcher, class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"testPlayerAnimation").then(class_2170.method_9244((String)"animationID", (ArgumentType)class_2232.method_9441()).suggests(new AnimationArgumentProvider()).executes(PlayerAnimCommands::execute)));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"testLegacyAnimationBinary").then(class_2170.method_9244((String)"animationID", (ArgumentType)class_2232.method_9441()).suggests(new AnimationArgumentProvider()).then(class_2170.method_9244((String)"version", (ArgumentType)IntegerArgumentType.integer((int)1, (int)LegacyAnimationBinary.getCurrentVersion())).executes(PlayerAnimCommands::executeLegacy))));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"testAnimationBinary").then(class_2170.method_9244((String)"animationID", (ArgumentType)class_2232.method_9441()).suggests(new AnimationArgumentProvider()).then(class_2170.method_9244((String)"version", (ArgumentType)IntegerArgumentType.integer((int)1, (int)4)).executes(PlayerAnimCommands::executeBinary))));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"testMannequin").then(class_2170.method_9244((String)"animationID", (ArgumentType)class_2232.method_9441()).suggests(new AnimationArgumentProvider()).then(class_2170.method_9244((String)"mannequin", (ArgumentType)class_5242.method_27643()).executes(PlayerAnimCommands::executeMannequin))));
    }

    private static int execute(CommandContext<class_2168> context) {
        class_2960 animation = class_2232.method_9443(context, (String)"animationID");
        return PlayerAnimCommands.playAnimation(PlayerAnimResources.getAnimation(animation));
    }

    private static int executeLegacy(CommandContext<class_2168> context) {
        Animation animation = Objects.requireNonNull(PlayerAnimResources.getAnimation(class_2232.method_9443(context, (String)"animationID")));
        int version = IntegerArgumentType.getInteger(context, (String)"version");
        ByteBuf byteBuffer = Unpooled.buffer((int)LegacyAnimationBinary.calculateSize(animation, version));
        LegacyAnimationBinary.write(animation, byteBuffer, version);
        try {
            int n = PlayerAnimCommands.playAnimation(LegacyAnimationBinary.read(byteBuffer, version));
            return n;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            byteBuffer.release();
        }
    }

    private static int executeBinary(CommandContext<class_2168> context) {
        Animation animation = Objects.requireNonNull(PlayerAnimResources.getAnimation(class_2232.method_9443(context, (String)"animationID")));
        int version = IntegerArgumentType.getInteger(context, (String)"version");
        ByteBuf byteBuf = Unpooled.buffer();
        AnimationBinary.write(byteBuf, version, animation);
        return PlayerAnimCommands.playAnimation(AnimationBinary.read(byteBuf, version));
    }

    private static int playAnimation(Animation animation) {
        AnimationController controller = (AnimationController)PlayerAnimationAccess.getPlayerAnimationLayer((class_11890)Objects.requireNonNull(class_310.method_1551().field_1724), PlayerAnimLibMod.ANIMATION_LAYER_ID);
        if (controller == null) {
            return 0;
        }
        controller.triggerAnimation(RawAnimation.begin().thenPlay(animation));
        return 1;
    }

    private static int executeMannequin(CommandContext<class_2168> context) {
        Animation animation = Objects.requireNonNull(PlayerAnimResources.getAnimation(class_2232.method_9443(context, (String)"animationID")));
        class_11890 avatar = (class_11890)Objects.requireNonNull(class_310.method_1551().field_1687.method_66347(class_5242.method_27645(context, (String)"mannequin")));
        AnimationController controller = (AnimationController)PlayerAnimationAccess.getPlayerAnimationLayer(avatar, PlayerAnimLibMod.ANIMATION_LAYER_ID);
        if (controller == null) {
            return 0;
        }
        controller.triggerAnimation(RawAnimation.begin().thenPlay(animation));
        return 1;
    }
}

