/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.gui;

import com.google.common.base.Suppliers;
import com.google.gson.JsonObject;
import com.wildfire.main.WildfireGender;
import com.wildfire.main.cloud.CloudSync;
import com.wildfire.main.contributors.Contributor;
import com.wildfire.main.contributors.Contributors;
import com.wildfire.main.entitydata.EntityConfig;
import com.wildfire.main.entitydata.PlayerConfig;
import com.wildfire.mixins.accessors.ClientMannequinEntityAccessor;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import net.minecraft.class_11786;
import net.minecraft.class_11903;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_8685;
import net.minecraft.class_9296;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FakeGUIPlayer {
    private final String name;
    private final UUID uuid;
    private final Supplier<GUIMannequin> entity;
    private final String description;

    public FakeGUIPlayer(@NotNull String name, @NotNull UUID uuid, @Nullable String description, @Nullable JsonObject defaultGenderSettings) {
        this.name = name;
        this.uuid = uuid;
        this.entity = FakeGUIPlayer.createPlayerSupplier(uuid, defaultGenderSettings);
        this.description = description;
    }

    public FakeGUIPlayer(@NotNull String name, @NotNull UUID uuid, @Nullable JsonObject defaultGenderSettings) {
        this(name, uuid, null, defaultGenderSettings);
    }

    @NotNull
    public class_11903 getEntity() {
        return this.entity.get();
    }

    @NotNull
    public UUID getUUID() {
        return this.uuid;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public Contributor.Role getRole() {
        return Contributors.getRole(this.uuid);
    }

    @NotNull
    public Contributor.Role getRoleOrGeneric() {
        Contributor.Role role = this.getRole();
        return role == null ? Contributor.Role.GENERIC : role;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void tick() {
        this.entity.get().applyLoadedSkin();
        ++this.entity.get().field_6012;
        EntityConfig.getEntity((class_1309)this.getEntity()).tickBreastPhysics((class_1309)this.getEntity());
    }

    private static Supplier<GUIMannequin> createPlayerSupplier(UUID uuid, JsonObject defaultGenderData) {
        return Suppliers.memoize(() -> {
            PlayerConfig config;
            class_310 client = class_310.method_1551();
            assert (client.field_1687 != null);
            GUIMannequin entity = new GUIMannequin((class_1937)client.field_1687, client.method_73362(), class_9296.method_73312((UUID)uuid));
            try {
                config = (PlayerConfig)EntityConfig.CACHE.get((Object)entity.method_5667(), () -> new PlayerConfig(entity.method_5667()));
            }
            catch (ClassCastException | ExecutionException ignored) {
                return entity;
            }
            config.forceSimplifiedPhysics = true;
            PlayerConfig cached = WildfireGender.getPlayerById(uuid);
            if (cached == null) {
                CloudSync.getProfile(uuid, true).thenAccept(json -> {
                    if (json != null) {
                        config.updateFromJson((JsonObject)json);
                    } else if (defaultGenderData != null) {
                        config.updateFromJson(defaultGenderData);
                    }
                });
            } else {
                config.updateFromJson(cached.toJson());
            }
            return entity;
        });
    }

    private static class GUIMannequin
    extends class_11903 {
        private final class_9296 copySkinFrom;

        public GUIMannequin(class_1937 world, class_11786 skinCache, class_9296 copySkinFrom) {
            super(world, skinCache);
            this.copySkinFrom = copySkinFrom;
            ((ClientMannequinEntityAccessor)((Object)this)).invokeRefreshSkin();
        }

        public void applyLoadedSkin() {
            ClientMannequinEntityAccessor accessor = (ClientMannequinEntityAccessor)((Object)this);
            CompletableFuture<Optional<class_8685>> skinLookup = accessor.getSkinLookup();
            if (skinLookup != null && skinLookup.isDone()) {
                try {
                    skinLookup.get().ifPresent(accessor::invokeSetSkin);
                    accessor.setSkinLookup(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        protected class_9296 method_74104() {
            return this.copySkinFrom;
        }
    }
}

