/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.gui.screen;

import com.wildfire.gui.GuiUtils;
import com.wildfire.gui.screen.BaseWildfireScreen;
import com.wildfire.main.config.Configuration;
import com.wildfire.main.entitydata.PlayerConfig;
import com.wildfire.main.uvs.BreastTypes;
import com.wildfire.main.uvs.UVDirection;
import com.wildfire.main.uvs.UVLayout;
import com.wildfire.main.uvs.UVQuad;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_10799;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_437;
import net.minecraft.class_490;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6880;
import net.minecraft.class_9848;
import org.joml.Vector2i;

public class WildfireBreastUVEditorScreen
extends BaseWildfireScreen {
    private static final class_2561 TITLE = class_2561.method_43471((String)"wildfire_gender.uv_editor");
    private static final class_2960 TEXTURE_ADD = class_2960.method_60655((String)"wildfire_gender", (String)"textures/gui/widgets/add.png");
    private static final class_2960 TEXTURE_SUBTRACT = class_2960.method_60655((String)"wildfire_gender", (String)"textures/gui/widgets/subtract.png");
    private UVLayout selectedUVs = null;
    private BreastTypes selectedBreastIndex = BreastTypes.LEFT;
    private UVDirection selectedDirection = null;
    private Vector2i winElementPos;
    private Vector2i uvWindowPos;
    private static final int sidebarWidth = 180;
    private static final int textureDrawWidth = 196;
    private static final int textureSourceWidth = 64;
    private static final float uvWindowScaleFactor = 3.0625f;

    public WildfireBreastUVEditorScreen(class_437 parent, UUID uuid) {
        super((class_2561)class_2561.method_43471((String)"wildfire_gender.uv_editor"), parent, uuid);
    }

    public void method_25426() {
        if (this.field_22787 == null) {
            return;
        }
        this.uvWindowPos = new Vector2i(5, this.field_22790 / 2 - 98);
        this.winElementPos = new Vector2i(this.field_22789 - 180 + 7, 32);
        int x = this.field_22789 - 180;
        int w = this.field_22789 - (this.field_22789 - 180);
        int y = 0;
        this.addButton(builder -> builder.message(() -> class_2561.method_43471((String)"wildfire_gender.uv_editor.reset_defaults_all")).position(x + 5, y + 5).size(this.field_22789 - x - 10, 20).onPress(button -> {
            PlayerConfig player = Objects.requireNonNull(this.getPlayer(), "getPlayer()");
            player.updateLeftBreastUVLayout(Configuration.LEFT_BREAST_UV_LAYOUT.getDefault());
            player.updateRightBreastUVLayout(Configuration.RIGHT_BREAST_UV_LAYOUT.getDefault());
            player.updateLeftBreastOverlayUVLayout(Configuration.LEFT_BREAST_OVERLAY_UV_LAYOUT.getDefault());
            player.updateRightBreastOverlayUVLayout(Configuration.RIGHT_BREAST_OVERLAY_UV_LAYOUT.getDefault());
            player.save();
        }));
        this.addButton(builder -> builder.message(() -> class_2561.method_43471((String)"wildfire_gender.uv_editor.selection.left_breast")).position(this.winElementPos.x(), this.winElementPos.y() + 13).size(w / 2 / 2 - 5, 15).active(this.selectedBreastIndex != BreastTypes.LEFT).onPress(button -> this.selectBreastUVMap(BreastTypes.LEFT)));
        this.addButton(builder -> builder.message(() -> class_2561.method_43471((String)"wildfire_gender.uv_editor.selection.right_breast")).position(this.winElementPos.x() + w / 2 / 2 - 3, this.winElementPos.y() + 13).size(w / 2 / 2 - 6, 15).active(this.selectedBreastIndex != BreastTypes.RIGHT).onPress(button -> this.selectBreastUVMap(BreastTypes.RIGHT)));
        this.addButton(builder -> builder.message(() -> class_2561.method_43471((String)"wildfire_gender.uv_editor.selection.left_breast_overlay")).position(this.winElementPos.x(), this.winElementPos.y() + 44).size(w / 2 / 2 - 5, 15).active(this.selectedBreastIndex != BreastTypes.LEFT_OVERLAY).onPress(button -> this.selectBreastUVMap(BreastTypes.LEFT_OVERLAY)));
        this.addButton(builder -> builder.message(() -> class_2561.method_43471((String)"wildfire_gender.uv_editor.selection.right_breast_overlay")).position(this.winElementPos.x() + w / 2 / 2 - 3, this.winElementPos.y() + 44).size(w / 2 / 2 - 6, 15).active(this.selectedBreastIndex != BreastTypes.RIGHT_OVERLAY).onPress(button -> this.selectBreastUVMap(BreastTypes.RIGHT_OVERLAY)));
        if (this.selectedDirection != null) {
            int uvPositionWindowX = this.field_22789 - 130 + 5;
            int buttonArrayY = 52;
            for (int i = 0; i < 8; ++i) {
                boolean isAdd = i % 2 == 1;
                int uvIndex = i / 2;
                int delta = isAdd ? 1 : -1;
                int xOffset = isAdd ? 106 : 92;
                int yOffset = i / 2 * 14;
                this.addButton(builder -> builder.renderer((button, ctx, mouseX, mouseY, partialTicks) -> {
                    int increment = this.getPositionIncrement();
                    class_124 colorVal = increment == 10 ? class_124.field_1075 : (increment == 20 ? class_124.field_1078 : class_124.field_1068);
                    ctx.method_25293(class_10799.field_56883, isAdd ? TEXTURE_ADD : TEXTURE_SUBTRACT, button.method_46426() + button.method_25368() / 2 - 3, button.method_46427() + button.method_25364() / 2 - 3, 0.0f, 0.0f, 6, 6, 6, 6, 6, 6, class_9848.method_61334((int)Objects.requireNonNull(colorVal.method_532())));
                }).message(() -> isAdd ? class_2561.method_43471((String)"wildfire_gender.uv_editor.add") : class_2561.method_43471((String)"wildfire_gender.uv_editor.remove")).position(uvPositionWindowX + xOffset, y + buttonArrayY + yOffset).size(12, 12).onPress(button -> {
                    if (this.selectedDirection == null) {
                        return;
                    }
                    PlayerConfig player = Objects.requireNonNull(this.getPlayer(), "getPlayer()");
                    UVQuad quad = this.selectedUVs.getAllSides().get((Object)this.selectedDirection);
                    int increment = this.getPositionIncrement();
                    int toAdd = delta * increment;
                    quad = uvIndex == 0 ? quad.addX1(toAdd).addX2(toAdd) : (uvIndex == 1 ? quad.addY1(toAdd).addY2(toAdd) : (uvIndex == 2 ? quad.addX2(toAdd) : quad.addY2(toAdd)));
                    this.selectedUVs.put(this.selectedDirection, quad);
                    player.save();
                }));
            }
        }
    }

    private void selectBreastUVMap(BreastTypes breast) {
        this.selectedBreastIndex = breast;
        this.selectedDirection = null;
        this.method_41843();
    }

    public void method_25420(class_332 ctx, int mouseX, int mouseY, float delta) {
        this.method_52752(ctx);
        int w = this.field_22789 - (this.field_22789 - 180) - 10;
        ctx.method_25294(this.field_22789 - 180, 0, this.field_22789, this.field_22790, -872415232);
        ctx.method_25294(this.field_22789 - 180 + 5, 30, this.field_22789 - w / 2 - 5, 93, 0x66000000);
        ctx.method_25294(this.field_22789 - w / 2, 30, this.field_22789 - 5, 128, 0x66000000);
        ctx.method_25294(this.uvWindowPos.x() - 2, this.uvWindowPos.y() - 2, this.uvWindowPos.x() + 196 + 2, this.uvWindowPos.y() + 196 + 2, -872415232);
        ctx.method_25294(this.uvWindowPos.x(), this.uvWindowPos.y(), this.uvWindowPos.x() + 196, this.uvWindowPos.y() + 196, -1);
    }

    public void method_25393() {
        PlayerConfig player = this.getPlayer();
        if (player == null) {
            return;
        }
        this.selectedUVs = switch (this.selectedBreastIndex) {
            case BreastTypes.RIGHT -> player.getRightBreastUVLayout();
            case BreastTypes.LEFT_OVERLAY -> player.getLeftBreastOverlayUVLayout();
            case BreastTypes.RIGHT_OVERLAY -> player.getRightBreastOverlayUVLayout();
            default -> player.getLeftBreastUVLayout();
        };
    }

    public void method_25394(class_332 ctx, int mouseX, int mouseY, float delta) {
        if (this.field_22787 == null || this.field_22787.field_1687 == null || this.field_22787.field_1724 == null) {
            return;
        }
        PlayerConfig player = this.getPlayer();
        if (player != null && this.selectedUVs != null) {
            UVLayout[] ALL_UVS;
            ctx.method_25290(class_10799.field_56883, this.field_22787.field_1724.method_52814().comp_1626().comp_3626(), this.uvWindowPos.x(), this.uvWindowPos.y(), 0.0f, 0.0f, 196, 196, 196, 196);
            for (UVLayout eachBreast : ALL_UVS = new UVLayout[]{player.getLeftBreastUVLayout(), player.getRightBreastUVLayout(), player.getLeftBreastOverlayUVLayout(), player.getRightBreastOverlayUVLayout()}) {
                this.drawFaceBorders(ctx, eachBreast, mouseX, mouseY, true);
            }
            this.drawFaceBorders(ctx, this.selectedUVs, mouseX, mouseY, false);
        }
        GuiUtils.drawCenteredText(ctx, this.field_22793, (class_2561)class_2561.method_43471((String)"wildfire_gender.uv_editor.selection.layer_body"), this.winElementPos.x() + 42, this.winElementPos.y() + 2, -1);
        GuiUtils.drawCenteredText(ctx, this.field_22793, (class_2561)class_2561.method_43471((String)"wildfire_gender.uv_editor.selection.layer_jacket"), this.winElementPos.x() + 42, this.winElementPos.y() + 32, -1);
        int positionBoxX = this.field_22789 - 45;
        if (this.selectedDirection == null) {
            GuiUtils.drawCenteredTextWrapped(ctx, this.field_22793, (class_5348)class_2561.method_43471((String)"wildfire_gender.uv_editor.no_face_selected"), positionBoxX, 60, 70, -7829368);
        } else {
            GuiUtils.drawCenteredText(ctx, this.field_22793, (class_2561)class_2561.method_43473().method_10852(this.selectedDirection.getDirectionText(this.selectedBreastIndex)).method_27692(class_124.field_1065), positionBoxX, 37, -1);
            ctx.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"wildfire_gender.uv_editor.xpos"), positionBoxX - 35, 55, -1, false);
            ctx.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"wildfire_gender.uv_editor.ypos"), positionBoxX - 35, 69, -1, false);
            ctx.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"wildfire_gender.uv_editor.width"), positionBoxX - 35, 83, -1, false);
            ctx.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"wildfire_gender.uv_editor.height"), positionBoxX - 35, 97, -1, false);
            ctx.method_51448().pushMatrix();
            ctx.method_51448().translate((float)positionBoxX, 115.0f);
            ctx.method_51448().scale(0.75f);
            GuiUtils.drawCenteredTextWrapped(ctx, this.field_22793, (class_5348)class_2561.method_43471((String)"wildfire_gender.uv_editor.increment_tip.line1").method_27692(class_124.field_1075), 0, -6, 120, -7829368);
            GuiUtils.drawCenteredTextWrapped(ctx, this.field_22793, (class_5348)class_2561.method_43471((String)"wildfire_gender.uv_editor.increment_tip.line2").method_27692(class_124.field_1078), 0, 6, 120, -7829368);
            ctx.method_51448().popMatrix();
        }
        int modelScale = 120;
        if (class_310.method_1551().method_22683().method_4480() < 1920) {
            modelScale = 60;
        } else if (class_310.method_1551().method_22683().method_4480() >= 2560) {
            modelScale = 200;
        }
        class_490.method_2486((class_332)ctx, (int)(this.field_22789 / 2 - modelScale), (int)(this.field_22790 / 2 - modelScale), (int)(this.field_22789 / 2 + modelScale), (int)(this.field_22790 / 2 + modelScale), (int)modelScale, (float)0.0625f, (float)mouseX, (float)mouseY, (class_1309)this.field_22787.field_1724);
        GuiUtils.drawCenteredText(ctx, this.field_22793, TITLE, this.field_22789 / 2, 20, -1);
        super.method_25394(ctx, mouseX, mouseY, delta);
    }

    private void drawFaceBorders(class_332 ctx, UVLayout uvList, int mouseX, int mouseY, boolean faded) {
        for (Map.Entry<UVDirection, UVQuad> entry : uvList.getAllSides().entrySet()) {
            UVDirection direction = entry.getKey();
            UVQuad quad = entry.getValue();
            int borderColor = this.selectedDirection == direction && !faded ? -1 : direction.getFaceColor(faded);
            String faceName = direction.getShortName();
            if (quad.x1() == 0 && quad.y1() == 0 && quad.x2() == 0 && quad.y2() == 0) continue;
            int rectX1 = (int)((float)this.uvWindowPos.x() + (float)quad.x1() * 3.0625f);
            int rectY1 = (int)((float)this.uvWindowPos.y() + (float)(quad.y1() - 1) * 3.0625f);
            int rectX2 = (int)((float)this.uvWindowPos.x() + (float)quad.x2() * 3.0625f);
            int rectY2 = (int)((float)this.uvWindowPos.y() + (float)(quad.y2() - 1) * 3.0625f);
            if (mouseX >= rectX1 && mouseX <= rectX2 && mouseY >= rectY1 && mouseY <= rectY2) {
                ArrayList<class_5481> array = new ArrayList<class_5481>();
                array.add(class_2561.method_43473().method_10852(direction.getDirectionText(this.selectedBreastIndex)).method_27693(" (").method_27693(faceName).method_27693(")").method_27692(class_124.field_1065).method_30937());
                array.add(class_2561.method_43473().method_27693("[" + quad.x1() + ", " + quad.y1() + ", " + quad.x2() + ", " + quad.y2() + "]").method_27692(class_124.field_1075).method_30937());
                ctx.method_71274(array, mouseX, mouseY);
            }
            int borderThickness = 1;
            ctx.method_25294(rectX1, rectY1, rectX2, rectY1 + borderThickness, borderColor);
            ctx.method_25294(rectX1, rectY2 - borderThickness, rectX2, rectY2, borderColor);
            ctx.method_25294(rectX1, rectY1, rectX1 + borderThickness, rectY2, borderColor);
            ctx.method_25294(rectX2 - borderThickness, rectY1, rectX2, rectY2, borderColor);
            int centerX = (rectX1 + rectX2) / 2;
            int centerY = (rectY1 + rectY2) / 2;
            int textWidth = this.field_22793.method_1727(faceName);
            Objects.requireNonNull(this.field_22793);
            int textHeight = 9;
            ctx.method_51448().pushMatrix();
            ctx.method_51448().translate((float)centerX, (float)centerY);
            ctx.method_51448().scale(0.6f);
            ctx.method_51433(this.field_22793, faceName, -textWidth / 2, -textHeight / 2, -1, true);
            ctx.method_51448().popMatrix();
        }
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        if (this.selectedUVs == null) {
            return super.method_25402(click, doubled);
        }
        for (Map.Entry<UVDirection, UVQuad> entry : this.selectedUVs.getAllSides().entrySet()) {
            UVDirection direction = entry.getKey();
            UVQuad quad = entry.getValue();
            if (quad.x1() == 0 && quad.y1() == 0 && quad.x2() == 0 && quad.y2() == 0) continue;
            int rectX1 = (int)((float)this.uvWindowPos.x() + (float)quad.x1() * 3.0625f);
            int rectY1 = (int)((float)this.uvWindowPos.y() + (float)(quad.y1() - 1) * 3.0625f);
            int rectX2 = (int)((float)this.uvWindowPos.x() + (float)quad.x2() * 3.0625f);
            int rectY2 = (int)((float)this.uvWindowPos.y() + (float)(quad.y2() - 1) * 3.0625f);
            if (!(click.comp_4798() >= (double)rectX1) || !(click.comp_4798() <= (double)rectX2) || !(click.comp_4799() >= (double)rectY1) || !(click.comp_4799() <= (double)rectY2)) continue;
            if (click.method_74245() == 0) {
                if (this.selectedDirection != direction) {
                    class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                    this.selectedDirection = direction;
                    this.method_41843();
                }
            } else if (click.method_74245() == 1 && this.selectedDirection != null) {
                this.selectedDirection = null;
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                this.method_41843();
            }
            return true;
        }
        return super.method_25402(click, doubled);
    }

    private int getPositionIncrement() {
        Objects.requireNonNull(this.field_22787);
        if (this.field_22787.method_74187() && this.field_22787.method_74188()) {
            return 20;
        }
        if (this.field_22787.method_74187()) {
            return 10;
        }
        return 1;
    }
}

