/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.main;

import com.google.common.cache.Cache;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.wildfire.gui.screen.WardrobeBrowserScreen;
import com.wildfire.gui.screen.WildfireFirstTimeSetupScreen;
import com.wildfire.main.WildfireGender;
import com.wildfire.main.config.ClientConfig;
import com.wildfire.main.config.enums.SyncVerbosity;
import com.wildfire.main.entitydata.BreastDataComponent;
import com.wildfire.main.entitydata.EntityConfig;
import com.wildfire.main.entitydata.PlayerConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1132;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1531;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2568;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.class_7157;
import net.minecraft.class_746;
import net.minecraft.class_7924;
import net.minecraft.class_8053;
import net.minecraft.class_8055;
import net.minecraft.class_8057;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class WildfireCommand {
    private static final class_2561 COMMAND_PREFIX = class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"[").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"F").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)"GM").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)"] ").method_27692(class_124.field_1080));

    static void init() {
        ClientCommandRegistrationCallback.EVENT.register(WildfireCommand::register);
    }

    private static void register(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registry) {
        class_310 client = class_310.method_1551();
        LiteralArgumentBuilder debug = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"debug").executes(ctx -> {
            WildfireCommand.sendHelp((CommandContext<FabricClientCommandSource>)ctx, (class_2561)class_2561.method_43470((String)"Debug Commands:"), "invalidatecache", "Clears the player & entity caches", "target", "Show debug info for entity you are looking at", "cache [allPlayers] [showEntities]", "Display cached entities/players", "firsttime", "Display the first time setup screen", "syncverbosity [level]", "Change how verbose the sync log is");
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43473());
            WildfireCommand.sendHelp((CommandContext<FabricClientCommandSource>)ctx, (class_2561)class_2561.method_43470((String)"Singleplayer Commands:"), "trim [glint]", "Equips a chestplate with a trim pre-applied onto yourself", "armorstand", "Spawns an armor stand with armor copying your breast settings pre-equipped");
            return 1;
        })).then(ClientCommandManager.literal((String)"invalidatecache").executes(WildfireCommand::invalidateCache))).then(ClientCommandManager.literal((String)"target").executes(WildfireCommand::getEntityLookingAt))).then(ClientCommandManager.literal((String)"firsttime").executes(ctx -> {
            client.execute(() -> client.method_63588(() -> client.method_1507((class_437)new WildfireFirstTimeSetupScreen(null, client.field_1724.method_5667()))));
            return 1;
        }))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"cache").then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"allPlayers", (ArgumentType)BoolArgumentType.bool()).executes(WildfireCommand::getUsers)).then(ClientCommandManager.argument((String)"showEntities", (ArgumentType)BoolArgumentType.bool()).executes(WildfireCommand::getUsers)))).executes(WildfireCommand::getUsers))).then(ClientCommandManager.literal((String)"syncverbosity").then(ClientCommandManager.argument((String)"level", (ArgumentType)new SyncVerbosity.SyncVerbosityArgumentType()).executes(WildfireCommand::setLogLevel)));
        if (class_310.method_1551().method_1542()) {
            ((LiteralArgumentBuilder)debug.then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"trim").then(ClientCommandManager.argument((String)"glint", (ArgumentType)BoolArgumentType.bool()).executes(WildfireCommand::equipTrimmedChestplate))).executes(WildfireCommand::equipTrimmedChestplate))).then(ClientCommandManager.literal((String)"armorstand").executes(WildfireCommand::spawnArmorStand));
        }
        LiteralCommandNode root = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"femalegender").executes(WildfireCommand::openConfig)).then((ArgumentBuilder)debug));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"fgm").executes(WildfireCommand::openConfig)).redirect((CommandNode)root));
    }

    private static <T> T getOrDefault(CommandContext<FabricClientCommandSource> ctx, String name, T defaultValue, Class<T> clazz) {
        Object value = defaultValue;
        try {
            value = ctx.getArgument(name, clazz);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return value;
    }

    public static void send(CommandContext<FabricClientCommandSource> ctx, String text) {
        ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43473().method_10852(COMMAND_PREFIX).method_27693(text));
    }

    public static void send(CommandContext<FabricClientCommandSource> ctx, class_2561 text) {
        ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43473().method_10852(COMMAND_PREFIX).method_10852(text));
    }

    public static void sendHelp(CommandContext<FabricClientCommandSource> ctx, class_2561 header, String ... nameToDescription) {
        assert (nameToDescription.length % 2 == 0);
        ArrayList<class_5250> lines = new ArrayList<class_5250>();
        lines.add(class_2561.method_43473().method_10852(COMMAND_PREFIX).method_10852(header).method_27692(class_124.field_1073));
        for (int i = 0; i < nameToDescription.length / 2; ++i) {
            String name = nameToDescription[i * 2];
            String description = nameToDescription[i * 2 + 1];
            lines.add(class_2561.method_43473().method_10852(COMMAND_PREFIX).method_10852((class_2561)class_2561.method_43470((String)name).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" - ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)description)));
        }
        ((FabricClientCommandSource)ctx.getSource()).sendFeedback(class_2564.method_37112(lines, (class_2561)class_2561.method_43470((String)"\n")));
    }

    private static int openConfig(CommandContext<FabricClientCommandSource> ctx) {
        class_310 client = ((FabricClientCommandSource)ctx.getSource()).getClient();
        class_746 player = ((FabricClientCommandSource)ctx.getSource()).getPlayer();
        client.method_63588(() -> WardrobeBrowserScreen.open(client, player));
        return 1;
    }

    private static int getEntityLookingAt(CommandContext<FabricClientCommandSource> ctx) {
        class_1297 target = ((FabricClientCommandSource)ctx.getSource()).getClient().field_1692;
        if (target != null) {
            WildfireCommand.send(ctx, "Looking at: " + target.method_5477().getString());
            WildfireCommand.send(ctx, "UUID: " + target.method_5845());
            WildfireCommand.send(ctx, "Type: " + String.valueOf(target.method_5864()));
            WildfireCommand.send(ctx, "Class: " + String.valueOf(target.getClass()));
            WildfireCommand.send(ctx, "Renderer: " + String.valueOf(class_310.method_1551().method_1561().method_3953(target)));
        } else {
            WildfireCommand.send(ctx, "No entity in sight.");
        }
        return 1;
    }

    public static int setLogLevel(CommandContext<FabricClientCommandSource> ctx) {
        SyncVerbosity level = (SyncVerbosity)((Object)ctx.getArgument("level", SyncVerbosity.class));
        ClientConfig.INSTANCE.set(ClientConfig.SYNC_VERBOSITY, level);
        ClientConfig.INSTANCE.save();
        WildfireCommand.send(ctx, "Log level set to: " + String.valueOf((Object)level));
        return 1;
    }

    private static int getUsers(CommandContext<FabricClientCommandSource> ctx) {
        List<class_2561> entities;
        boolean allPlayers = WildfireCommand.getOrDefault(ctx, "allPlayers", false, Boolean.class);
        boolean showEntities = WildfireCommand.getOrDefault(ctx, "showEntities", false, Boolean.class);
        List<class_2561> players = WildfireCommand.dump(WildfireGender.CACHE, (class_1937)((FabricClientCommandSource)ctx.getSource()).getWorld(), !allPlayers);
        if (!players.isEmpty()) {
            WildfireCommand.send(ctx, "Synced Players (" + players.size() + "):");
            for (class_2561 line : players) {
                WildfireCommand.send(ctx, line);
            }
        }
        if (showEntities && !(entities = WildfireCommand.dump(EntityConfig.CACHE, (class_1937)((FabricClientCommandSource)ctx.getSource()).getWorld(), false)).isEmpty()) {
            WildfireCommand.send(ctx, "Entities (" + players.size() + "):");
            for (class_2561 line : entities) {
                WildfireCommand.send(ctx, line);
            }
        }
        return 1;
    }

    private static List<class_2561> dump(Cache<UUID, ? extends EntityConfig> cache, @NotNull class_1937 world, boolean ignoreEmptyConfig) {
        ArrayList<class_2561> lines = new ArrayList<class_2561>();
        for (Map.Entry entry : cache.asMap().entrySet()) {
            class_1297 entity;
            PlayerConfig playerConfig;
            UUID uuid = (UUID)entry.getKey();
            EntityConfig config = (EntityConfig)entry.getValue();
            if (config == null || config instanceof PlayerConfig && (playerConfig = (PlayerConfig)config).getSyncStatus() == PlayerConfig.SyncStatus.UNKNOWN && ignoreEmptyConfig || (entity = world.method_66347(uuid)) == null) continue;
            class_5250 info = class_2564.method_36332(config.getDebugInfo(), (class_2561)class_2561.method_43470((String)"\n"), class_2561::method_43470);
            lines.add((class_2561)class_2561.method_43473().method_10852(entity.method_5476()).method_27693(" - ").method_10852(config.getGender().getDisplayName()).method_27694(style -> style.method_10949((class_2568)new class_2568.class_10613((class_2561)info))));
        }
        return lines;
    }

    private static int invalidateCache(CommandContext<FabricClientCommandSource> ctx) {
        WildfireGender.CACHE.invalidateAll();
        EntityConfig.CACHE.invalidateAll();
        WildfireCommand.send(ctx, "Cache has been invalidated!");
        return 1;
    }

    private static class_3222 getIntegratedServerPlayer(CommandContext<FabricClientCommandSource> ctx) {
        class_1132 integratedServer = Objects.requireNonNull(class_310.method_1551().method_1576());
        class_3324 playerManager = Objects.requireNonNull(integratedServer.method_3760());
        return Objects.requireNonNull(playerManager.method_14602(((FabricClientCommandSource)ctx.getSource()).getPlayer().method_5667()));
    }

    private static int equipTrimmedChestplate(CommandContext<FabricClientCommandSource> ctx) {
        Boolean glint = WildfireCommand.getOrDefault(ctx, "glint", null, Boolean.class);
        class_3222 player = WildfireCommand.getIntegratedServerPlayer(ctx);
        if (!player.method_64475(2)) {
            return 0;
        }
        class_1799 item = new class_1799((class_1935)class_1802.field_8523);
        class_6880.class_6883 material = player.method_56673().method_30530(class_7924.field_42083).method_46747(class_8055.field_42013);
        class_6880.class_6883 pattern = player.method_56673().method_30530(class_7924.field_42082).method_46747(class_8057.field_42018);
        item.method_57379(class_9334.field_49607, (Object)new class_8053((class_6880)material, (class_6880)pattern));
        if (glint != null) {
            item.method_57379(class_9334.field_49641, (Object)glint);
        }
        player.method_5673(class_1304.field_6174, item);
        return 1;
    }

    private static int spawnArmorStand(CommandContext<FabricClientCommandSource> ctx) {
        class_3222 player = WildfireCommand.getIntegratedServerPlayer(ctx);
        if (!player.method_64475(2)) {
            return 0;
        }
        class_3218 world = player.method_51469();
        class_1799 item = new class_1799((class_1935)class_1802.field_8523);
        PlayerConfig config = WildfireGender.getOrAddPlayerById(player.method_5667());
        BreastDataComponent component = BreastDataComponent.fromPlayer((class_1657)player, config);
        if (component == null) {
            ((FabricClientCommandSource)ctx.getSource()).sendError((class_2561)class_2561.method_43470((String)"Returned breast data component was null; do you have Hide in Armor on?"));
            return 0;
        }
        component.write(item);
        class_1531 stand = new class_1531((class_1937)world, (double)player.method_31477(), (double)player.method_31478(), (double)player.method_31479());
        stand.method_5673(class_1304.field_6169, new class_1799((class_1935)class_1802.field_8743));
        stand.method_5673(class_1304.field_6174, item);
        stand.method_5673(class_1304.field_6172, new class_1799((class_1935)class_1802.field_8396));
        stand.method_5673(class_1304.field_6166, new class_1799((class_1935)class_1802.field_8660));
        world.method_8649((class_1297)stand);
        return 1;
    }
}

