/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.main;

import com.google.gson.JsonObject;
import com.wildfire.main.WildfireCommand;
import com.wildfire.main.WildfireEventHandler;
import com.wildfire.main.WildfireGender;
import com.wildfire.main.WildfireSounds;
import com.wildfire.main.cloud.CloudSync;
import com.wildfire.main.config.ClientConfig;
import com.wildfire.main.config.Configuration;
import com.wildfire.main.contributors.Contributors;
import com.wildfire.main.entitydata.PlayerConfig;
import com.wildfire.main.networking.WildfireSync;
import com.wildfire.render.debug.GenderDebugHudEntry;
import com.wildfire.render.debug.PhysicsDebugHudEntry;
import com.wildfire.resources.GenderArmorResourceManager;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.resource.v1.ResourceLoader;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_11631;
import net.minecraft.class_11632;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3302;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class WildfireGenderClient
implements ClientModInitializer {
    private static final Executor LOAD_EXECUTOR = class_156.method_27958().method_64116("wildfire_gender$loadPlayerData");

    public void onInitializeClient() {
        WildfireSounds.register();
        WildfireSync.registerClient();
        WildfireEventHandler.registerClientEvents();
        ResourceLoader.get((class_3264)class_3264.field_14188).registerReloader(GenderArmorResourceManager.ID, (class_3302)GenderArmorResourceManager.INSTANCE);
        class_11631.method_72763((class_2960)GenderDebugHudEntry.SELF, (class_11632)new GenderDebugHudEntry(true));
        class_11631.method_72763((class_2960)GenderDebugHudEntry.OTHER, (class_11632)new GenderDebugHudEntry(false));
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            class_11631.method_72763((class_2960)PhysicsDebugHudEntry.ID, (class_11632)new PhysicsDebugHudEntry());
        }
        WildfireCommand.init();
        Path oldConfigDir = FabricLoader.getInstance().getConfigDir().resolve("WildfireGender");
        Path newConfigDir = FabricLoader.getInstance().getConfigDir().resolve(Configuration.getConfigFile());
        try {
            Files.move(oldConfigDir, newConfigDir, StandardCopyOption.REPLACE_EXISTING);
            WildfireGender.LOGGER.info("Migrated config folder from '{}' to '{}'", (Object)oldConfigDir, (Object)newConfigDir);
        }
        catch (IOException e) {
            WildfireGender.LOGGER.error("Failed to rename config folder", (Throwable)e);
        }
    }

    public static CompletableFuture<@Nullable PlayerConfig> loadGenderInfo(UUID uuid, boolean markForSync, boolean bypassQueue) {
        PlayerConfig cache = WildfireGender.getPlayerById(uuid);
        if (cache == null) {
            return CompletableFuture.completedFuture(null);
        }
        return WildfireGenderClient.loadGenderInfo(cache, markForSync, bypassQueue);
    }

    public static CompletableFuture<@NotNull PlayerConfig> loadGenderInfo(PlayerConfig player, boolean markForSync, boolean bypassQueue) {
        return CompletableFuture.supplyAsync(() -> {
            UUID uuid = player.uuid;
            if (player.hasLocalConfig()) {
                player.loadFromDisk(markForSync);
            } else if (player.syncStatus == PlayerConfig.SyncStatus.UNKNOWN) {
                JsonObject data;
                try {
                    CompletableFuture<JsonObject> future = bypassQueue ? CloudSync.getProfile(uuid) : CloudSync.queueFetch(uuid);
                    data = future.join();
                }
                catch (Exception e) {
                    WildfireGender.LOGGER.error("Failed to fetch profile from sync server", (Throwable)e);
                    throw e;
                }
                if (data != null && player.syncStatus == PlayerConfig.SyncStatus.UNKNOWN) {
                    player.updateFromJson(data);
                    if (markForSync) {
                        player.needsSync = true;
                    }
                }
            }
            return player;
        }, LOAD_EXECUTOR);
    }

    @Nullable
    public static class_2561 getNametag(UUID uuid) {
        class_746 clientPlayer = class_310.method_1551().field_1724;
        if (ClientConfig.INSTANCE.get(ClientConfig.HIDE_OWN_CONTRIBUTOR_TAG).booleanValue() && clientPlayer != null && uuid.equals(clientPlayer.method_5667())) {
            return null;
        }
        return Contributors.getNametag(uuid);
    }
}

