/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.main.config.types;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.wildfire.main.config.types.ConfigKey;
import com.wildfire.main.uvs.UVDirection;
import com.wildfire.main.uvs.UVLayout;
import com.wildfire.main.uvs.UVQuad;

public class UVLayoutConfigKey
extends ConfigKey<UVLayout> {
    public UVLayoutConfigKey(String key, UVLayout defaultValue) {
        super(key, defaultValue);
    }

    @Override
    protected UVLayout read(JsonElement element) {
        if (!element.isJsonObject()) {
            return ((UVLayout)this.defaultValue).copy();
        }
        JsonObject obj = element.getAsJsonObject();
        UVLayout layout = new UVLayout();
        for (UVDirection dir : UVDirection.values()) {
            JsonElement sideElem = obj.get(dir.getSaveName());
            if (sideElem == null || !sideElem.isJsonObject()) continue;
            JsonObject quadObj = sideElem.getAsJsonObject();
            int x1 = quadObj.get("x1").getAsInt();
            int y1 = quadObj.get("y1").getAsInt();
            int x2 = quadObj.get("x2").getAsInt();
            int y2 = quadObj.get("y2").getAsInt();
            layout.put(dir, new UVQuad(x1, y1, x2, y2));
        }
        return layout;
    }

    @Override
    public void save(JsonObject object, UVLayout value) {
        JsonObject layoutObj = new JsonObject();
        for (UVDirection dir : UVDirection.values()) {
            UVQuad quad = value.get(dir);
            if (quad == null) continue;
            JsonObject quadObj = new JsonObject();
            quadObj.addProperty("x1", (Number)quad.x1());
            quadObj.addProperty("y1", (Number)quad.y1());
            quadObj.addProperty("x2", (Number)quad.x2());
            quadObj.addProperty("y2", (Number)quad.y2());
            layoutObj.add(dir.getSaveName(), (JsonElement)quadObj);
        }
        object.add(this.key, (JsonElement)layoutObj);
    }

    @Override
    public UVLayout getDefault() {
        return ((UVLayout)this.defaultValue).copy();
    }
}

