/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.main.entitydata;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.wildfire.api.IGenderArmor;
import com.wildfire.main.WildfireGender;
import com.wildfire.main.WildfireHelper;
import com.wildfire.main.config.Configuration;
import com.wildfire.main.config.enums.Gender;
import com.wildfire.main.config.types.ConfigKey;
import com.wildfire.main.entitydata.BreastDataComponent;
import com.wildfire.main.entitydata.Breasts;
import com.wildfire.main.uvs.UVLayout;
import com.wildfire.physics.BreastPhysics;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11890;
import net.minecraft.class_124;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1531;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityConfig {
    public static final LoadingCache<UUID, EntityConfig> CACHE = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofMinutes(5L)).build((CacheLoader)new CacheLoader<UUID, EntityConfig>(){

        @NotNull
        public EntityConfig load(@NotNull UUID key) {
            return new EntityConfig(key);
        }
    });
    public final UUID uuid;
    protected Gender gender = (Gender)((Object)Configuration.GENDER.getDefault());
    protected float pBustSize = ((Float)Configuration.BUST_SIZE.getDefault()).floatValue();
    protected boolean breastPhysics = (Boolean)Configuration.BREAST_PHYSICS.getDefault();
    protected float bounceMultiplier = ((Float)Configuration.BOUNCE_MULTIPLIER.getDefault()).floatValue();
    protected float floppyMultiplier = ((Float)Configuration.FLOPPY_MULTIPLIER.getDefault()).floatValue();
    protected UVLayout leftBreastUVLayout = Configuration.LEFT_BREAST_UV_LAYOUT.getDefault();
    protected UVLayout rightBreastUVLayout = Configuration.RIGHT_BREAST_UV_LAYOUT.getDefault();
    protected UVLayout leftBreastOverlayUVLayout = Configuration.LEFT_BREAST_OVERLAY_UV_LAYOUT.getDefault();
    protected UVLayout rightBreastOverlayUVLayout = Configuration.RIGHT_BREAST_OVERLAY_UV_LAYOUT.getDefault();
    protected UVLayout leftBreastArmorUVLayout = Configuration.LEFT_BREAST_ARMOR_UV_LAYOUT.getDefault();
    protected UVLayout rightBreastArmorUVLayout = Configuration.RIGHT_BREAST_ARMOR_UV_LAYOUT.getDefault();
    protected float voicePitch = ((Float)Configuration.VOICE_PITCH.getDefault()).floatValue();
    protected final BreastPhysics lBreastPhysics;
    protected final BreastPhysics rBreastPhysics;
    protected final Breasts breasts;
    protected boolean jacketLayer = true;
    @Nullable
    protected BreastDataComponent fromComponent;
    @ApiStatus.Internal
    public boolean forceSimplifiedPhysics = false;

    protected EntityConfig(UUID uuid) {
        this.uuid = uuid;
        this.breasts = new Breasts();
        this.lBreastPhysics = new BreastPhysics(this);
        this.rBreastPhysics = new BreastPhysics(this);
    }

    public void readFromStack(@NotNull class_1799 chestplate) {
        class_9279 component = (class_9279)chestplate.method_58694(class_9334.field_49628);
        if (chestplate.method_7960() || component == null) {
            this.fromComponent = null;
            this.gender = Gender.MALE;
            return;
        }
        if (this.fromComponent != null && Objects.equals(component, this.fromComponent.nbtComponent())) {
            return;
        }
        this.fromComponent = BreastDataComponent.fromComponent(component);
        if (this.fromComponent == null) {
            this.gender = Gender.MALE;
            return;
        }
        this.breastPhysics = false;
        this.pBustSize = this.fromComponent.breastSize();
        this.gender = this.pBustSize >= 0.02f ? Gender.FEMALE : Gender.MALE;
        this.breasts.updateCleavage(this.fromComponent.cleavage());
        this.breasts.updateOffsets(this.fromComponent.offsets());
        this.jacketLayer = this.fromComponent.jacket();
    }

    public static boolean isSupportedEntity(class_1309 entity) {
        return entity instanceof class_11890 || entity instanceof class_1531;
    }

    @NotNull
    public static EntityConfig getEntity(@NotNull class_1309 entity) {
        if (entity instanceof class_1657) {
            return WildfireGender.getOrAddPlayerById(entity.method_5667());
        }
        return (EntityConfig)CACHE.getUnchecked((Object)entity.method_5667());
    }

    @NotNull
    public Gender getGender() {
        return this.gender;
    }

    @NotNull
    public Breasts getBreasts() {
        return this.breasts;
    }

    public float getBustSize() {
        return this.pBustSize;
    }

    public boolean hasBreastPhysics() {
        return this.breastPhysics;
    }

    @ApiStatus.Obsolete
    @Environment(value=EnvType.CLIENT)
    public boolean getArmorPhysicsOverride() {
        return false;
    }

    public boolean showBreastsInArmor() {
        return true;
    }

    public float getBounceMultiplier() {
        return this.bounceMultiplier;
    }

    public float getFloppiness() {
        return this.floppyMultiplier;
    }

    public float getVoicePitch() {
        return this.voicePitch;
    }

    @NotNull
    public BreastPhysics getLeftBreastPhysics() {
        return this.lBreastPhysics;
    }

    @NotNull
    public BreastPhysics getRightBreastPhysics() {
        return this.rBreastPhysics;
    }

    public UVLayout getLeftBreastUVLayout() {
        return this.leftBreastUVLayout;
    }

    public boolean updateLeftBreastUVLayout(UVLayout layout) {
        return this.updateValue(Configuration.LEFT_BREAST_UV_LAYOUT, layout, v -> {
            this.leftBreastUVLayout = v;
        });
    }

    public UVLayout getRightBreastUVLayout() {
        return this.rightBreastUVLayout;
    }

    public boolean updateRightBreastUVLayout(UVLayout layout) {
        return this.updateValue(Configuration.RIGHT_BREAST_UV_LAYOUT, layout, v -> {
            this.rightBreastUVLayout = v;
        });
    }

    public UVLayout getLeftBreastOverlayUVLayout() {
        return this.leftBreastOverlayUVLayout;
    }

    public boolean updateLeftBreastOverlayUVLayout(UVLayout layout) {
        return this.updateValue(Configuration.LEFT_BREAST_OVERLAY_UV_LAYOUT, layout, v -> {
            this.leftBreastOverlayUVLayout = v;
        });
    }

    public UVLayout getRightBreastOverlayUVLayout() {
        return this.rightBreastOverlayUVLayout;
    }

    public boolean updateRightBreastOverlayUVLayout(UVLayout layout) {
        return this.updateValue(Configuration.RIGHT_BREAST_OVERLAY_UV_LAYOUT, layout, v -> {
            this.rightBreastOverlayUVLayout = v;
        });
    }

    @Deprecated(forRemoval=true)
    public UVLayout getLeftBreastArmorUVLayout() {
        return this.leftBreastArmorUVLayout;
    }

    @Deprecated(forRemoval=true)
    public UVLayout getRightBreastArmorUVLayout() {
        return this.rightBreastArmorUVLayout;
    }

    protected <VALUE> boolean updateValue(ConfigKey<VALUE> key, VALUE value, Consumer<VALUE> setter) {
        if (key.validate(value)) {
            setter.accept(value);
            return true;
        }
        return false;
    }

    public boolean hasJacketLayer() {
        return this.jacketLayer;
    }

    @Environment(value=EnvType.CLIENT)
    public void tickBreastPhysics(@NotNull class_1309 entity) {
        IGenderArmor armor = WildfireHelper.getArmorConfig(entity.method_6118(class_1304.field_6174));
        this.getLeftBreastPhysics().update(entity, armor);
        this.getRightBreastPhysics().update(entity, armor);
    }

    public String toString() {
        return "%s(uuid=%s, gender=%s)".formatted(new Object[]{this.getClass().getCanonicalName(), this.uuid, this.gender});
    }

    public List<String> getDebugInfo() {
        ArrayList<String> info = new ArrayList<String>();
        info.add("Gender: " + (switch (this.getGender()) {
            default -> throw new MatchException(null, null);
            case Gender.FEMALE -> String.valueOf(class_124.field_1076) + "Female";
            case Gender.MALE -> String.valueOf(class_124.field_1078) + "Male";
            case Gender.OTHER -> String.valueOf(class_124.field_1060) + "Other";
        }));
        info.add("Breast size: " + this.getBustSize());
        info.add("Physics enabled: " + this.hasBreastPhysics());
        Breasts breasts = this.getBreasts();
        info.add("Uniboob: " + breasts.isUniboob());
        info.add("Cleavage: " + breasts.getCleavage());
        info.add("Offsets: (" + breasts.getXOffset() + ", " + breasts.getYOffset() + ", " + breasts.getZOffset() + ")");
        return info;
    }
}

