/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.main.entitydata;

import com.google.gson.JsonObject;
import com.wildfire.gui.screen.BaseWildfireScreen;
import com.wildfire.main.WildfireGender;
import com.wildfire.main.WildfireLocalization;
import com.wildfire.main.cloud.CloudSync;
import com.wildfire.main.cloud.SyncLog;
import com.wildfire.main.config.ClientConfig;
import com.wildfire.main.config.Configuration;
import com.wildfire.main.config.enums.Gender;
import com.wildfire.main.entitydata.EntityConfig;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class PlayerConfig
extends EntityConfig {
    public boolean needsSync;
    public boolean needsCloudSync;
    public SyncStatus syncStatus = SyncStatus.UNKNOWN;
    private final Configuration cfg;
    protected boolean hurtSounds = (Boolean)Configuration.HURT_SOUNDS.getDefault();
    protected boolean holidayThemes = (Boolean)Configuration.HOLIDAY_THEMES.getDefault();
    protected boolean showBreastsInArmor = (Boolean)Configuration.SHOW_IN_ARMOR.getDefault();

    @Deprecated
    public PlayerConfig(UUID uuid, Gender gender) {
        this(uuid);
        this.updateGender(gender);
    }

    public PlayerConfig(UUID uuid) {
        super(uuid);
        this.cfg = new Configuration(uuid.toString());
        this.cfg.setDefaults();
        if (uuid.version() != 4) {
            this.holidayThemes = false;
        }
    }

    @Override
    public void readFromStack(@NotNull class_1799 chestplate) {
    }

    public Configuration getConfig() {
        return this.cfg;
    }

    public boolean updateGender(Gender value) {
        return this.updateValue(Configuration.GENDER, value, v -> {
            this.gender = v;
        });
    }

    public boolean updateBustSize(float value) {
        return this.updateValue(Configuration.BUST_SIZE, Float.valueOf(value), v -> {
            this.pBustSize = v.floatValue();
        });
    }

    public boolean hasHolidayThemes() {
        return this.holidayThemes;
    }

    public boolean updateHolidayThemes(boolean value) {
        return this.updateValue(Configuration.HOLIDAY_THEMES, value, v -> {
            this.holidayThemes = v;
        });
    }

    public boolean hasHurtSounds() {
        return this.hurtSounds;
    }

    public boolean updateVoicePitch(float value) {
        return this.updateValue(Configuration.VOICE_PITCH, Float.valueOf(value), v -> {
            this.voicePitch = v.floatValue();
        });
    }

    public boolean updateHurtSounds(boolean value) {
        return this.updateValue(Configuration.HURT_SOUNDS, value, v -> {
            this.hurtSounds = v;
        });
    }

    public boolean updateBreastPhysics(boolean value) {
        return this.updateValue(Configuration.BREAST_PHYSICS, value, v -> {
            this.breastPhysics = v;
        });
    }

    @Override
    @ApiStatus.Obsolete
    @Environment(value=EnvType.CLIENT)
    public boolean getArmorPhysicsOverride() {
        return ClientConfig.INSTANCE.get(ClientConfig.ARMOR_PHYSICS_OVERRIDE);
    }

    @Override
    public boolean showBreastsInArmor() {
        return this.showBreastsInArmor;
    }

    public boolean updateShowBreastsInArmor(boolean value) {
        return this.updateValue(Configuration.SHOW_IN_ARMOR, value, v -> {
            this.showBreastsInArmor = v;
        });
    }

    public boolean updateBounceMultiplier(float value) {
        return this.updateValue(Configuration.BOUNCE_MULTIPLIER, Float.valueOf(value), v -> {
            this.bounceMultiplier = v.floatValue();
        });
    }

    public boolean updateFloppiness(float value) {
        return this.updateValue(Configuration.FLOPPY_MULTIPLIER, Float.valueOf(value), v -> {
            this.floppyMultiplier = v.floatValue();
        });
    }

    public SyncStatus getSyncStatus() {
        return this.syncStatus;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        Configuration.KEYS.forEach(key -> key.dump(this, json));
        return json;
    }

    public boolean hasLocalConfig() {
        return this.cfg.exists();
    }

    public void loadFromDisk(boolean markForSync) {
        this.syncStatus = SyncStatus.CACHED;
        this.cfg.load();
        this.loadFromConfig(markForSync);
    }

    public void loadFromConfig(boolean markForSync) {
        Configuration.KEYS.forEach(key -> key.writeToPlayer(this));
        if (markForSync) {
            this.needsSync = true;
        }
    }

    public void writeToConfig() {
        Configuration.KEYS.forEach(key -> key.writeToConfig(this));
    }

    public void save() {
        this.writeToConfig();
        this.getConfig().save();
        this.needsSync = true;
        this.needsCloudSync = true;
    }

    @Deprecated(forRemoval=true)
    public static void saveGenderInfo(PlayerConfig plr) {
        plr.save();
    }

    @Override
    public boolean hasJacketLayer() {
        throw new UnsupportedOperationException("PlayerConfig does not support #hasJacketLayer(); use PlayerEntity#isPartVisible instead");
    }

    @ApiStatus.Internal
    public void attemptCloudSync() {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || !this.uuid.equals(client.field_1724.method_5667())) {
            return;
        }
        if (!this.needsCloudSync) {
            return;
        }
        if (client.field_1755 instanceof BaseWildfireScreen) {
            return;
        }
        if (!ClientConfig.INSTANCE.get(ClientConfig.AUTOMATIC_CLOUD_SYNC).booleanValue()) {
            return;
        }
        if (CloudSync.syncOnCooldown()) {
            return;
        }
        CompletableFuture.runAsync(() -> {
            try {
                CloudSync.sync(this).join();
                WildfireGender.LOGGER.info("Synced player data to the cloud");
            }
            catch (Exception e) {
                WildfireGender.LOGGER.error("Failed to sync player data", (Throwable)e);
                SyncLog.add(WildfireLocalization.SYNC_LOG_FAILED_TO_SYNC_DATA);
            }
        });
        this.needsCloudSync = false;
    }

    public void updateFromJson(@NotNull JsonObject json) {
        json.asMap().forEach(this.cfg::set);
        this.loadFromConfig(false);
        this.syncStatus = SyncStatus.SYNCED;
    }

    @Override
    public List<String> getDebugInfo() {
        List<String> lines = super.getDebugInfo();
        lines.add(1, "Sync status: " + String.valueOf((Object)this.getSyncStatus()));
        lines.add("Female hurt sounds: " + this.hasHurtSounds());
        lines.add("Show in armor: " + this.showBreastsInArmor());
        return lines;
    }

    public static enum SyncStatus {
        CACHED,
        SYNCED,
        UNKNOWN;

    }
}

