/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.main.networking;

import com.mojang.logging.LogUtils;
import com.wildfire.main.entitydata.PlayerConfig;
import com.wildfire.main.networking.ClientboundSyncPacket;
import com.wildfire.main.networking.ServerboundSyncPacket;
import com.wildfire.main.networking.SyncHelloPacket;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_8710;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public final class WildfireSync {
    static final Logger LOGGER = LogUtils.getLogger();

    private WildfireSync() {
        throw new UnsupportedOperationException();
    }

    @ApiStatus.Internal
    public static void register() {
        PayloadTypeRegistry.playC2S().register(ClientboundSyncPacket.ID, ClientboundSyncPacket.CODEC);
        PayloadTypeRegistry.playS2C().register(ClientboundSyncPacket.ID, ClientboundSyncPacket.CODEC);
        PayloadTypeRegistry.playC2S().register(ServerboundSyncPacket.ID, ServerboundSyncPacket.CODEC);
        PayloadTypeRegistry.playS2C().register(ServerboundSyncPacket.ID, ServerboundSyncPacket.CODEC);
        PayloadTypeRegistry.playC2S().register(SyncHelloPacket.Clientbound.ID, SyncHelloPacket.Clientbound.CODEC);
        PayloadTypeRegistry.playS2C().register(SyncHelloPacket.Clientbound.ID, SyncHelloPacket.Clientbound.CODEC);
        PayloadTypeRegistry.playC2S().register(SyncHelloPacket.Serverbound.ID, SyncHelloPacket.Serverbound.CODEC);
        PayloadTypeRegistry.playS2C().register(SyncHelloPacket.Serverbound.ID, SyncHelloPacket.Serverbound.CODEC);
        ServerPlayConnectionEvents.INIT.register((handler, server) -> {
            ServerPlayNetworking.registerReceiver((class_3244)handler, ServerboundSyncPacket.ID, ServerboundSyncPacket::handle);
            ServerPlayNetworking.registerReceiver((class_3244)handler, SyncHelloPacket.Serverbound.ID, SyncHelloPacket.Serverbound::handle);
        });
    }

    @ApiStatus.Internal
    @Environment(value=EnvType.CLIENT)
    public static void registerClient() {
        ClientPlayConnectionEvents.INIT.register((handler, client) -> {
            ClientPlayNetworking.registerReceiver(ClientboundSyncPacket.ID, ClientboundSyncPacket::handle);
            ClientPlayNetworking.registerReceiver(SyncHelloPacket.Clientbound.ID, SyncHelloPacket.Clientbound::handle);
        });
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            if (ClientPlayNetworking.canSend(SyncHelloPacket.Serverbound.ID)) {
                LOGGER.debug("Sending hello packet to server");
                sender.sendPacket((class_8710)new SyncHelloPacket.Serverbound());
            }
        });
    }

    public static void sendToAllClients(@NotNull class_3222 toSync, @NotNull PlayerConfig playerConfig) {
        PlayerLookup.tracking((class_1297)toSync).stream().filter(player -> !player.equals((Object)toSync)).filter(ClientboundSyncPacket::canSend).forEach(player -> ServerPlayNetworking.send((class_3222)player, (class_8710)new ClientboundSyncPacket(playerConfig)));
    }

    public static void sendToClient(@NotNull class_3222 sendTo, @NotNull PlayerConfig toSync) {
        if (ClientboundSyncPacket.canSend(sendTo)) {
            ServerPlayNetworking.send((class_3222)sendTo, (class_8710)new ClientboundSyncPacket(toSync));
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void sendToServer(@NotNull PlayerConfig plr) {
        if (!plr.needsSync || !ServerboundSyncPacket.canSend()) {
            return;
        }
        ClientPlayNetworking.send((class_8710)new ServerboundSyncPacket(plr));
        plr.needsSync = false;
    }
}

